const ObituariesAudioBG = require("../models/ObituariesAudioBG");
const fs = require("fs");
const path = require("path");

module.exports = {
  async  createObituaryAudioBackground(req, res) {

   
  try {
    if (req.file) {
      let filePath = req.file.path.replace("public", "api");

      const data = await ObituariesAudioBG.create({
        audio: filePath,
        obituaries_id: req.params.obituariesId,
      });

      return res.status(201).json({
        message: "Obituary background audio created successfully",
        data,
      });
    } else {
      return res.status(400).json({ message: "No audio file uploaded" });
    }
  } catch (error) {
    console.error(error);
    return res.status(500).json({ error: "Internal Server Error" });
  }
},

 async getObituaryAudioBackground(req, res) {
    try {
      // Fetch the audio background based on obituary ID
      const data = await ObituariesAudioBG.findOne({
        where: { obituaries_id: req.params.obituariesId },
      });

      // if (!data) {
      //   return res.status(404).json({ message: "No audio background found for this obituary" });
      // }

      return res.status(200).json({
        message: "Obituary background audio retrieved successfully",
        data,
      });
    } catch (error) {
      console.error(error);
      return res.status(500).json({ error: "Internal Server Error" });
    }
  }

  ,

  async  updateObituaryAudioBackground(req, res) {
  try {
    const { obituariesId } = req.params;

    if (!req.file) {
      return res.status(400).json({ message: "No audio file uploaded" });
    }

    // Find existing background audio
    const existingAudio = await ObituariesAudioBG.findOne({
      where: { obituaries_id: obituariesId },
    });

    let filePath = req.file.path.replace("public", "api");

    if (existingAudio) {
      // Optional: Delete old audio file from filesystem
      const oldPath = path.join("public", existingAudio.audio.replace("api", ""));
      if (fs.existsSync(oldPath)) {
        fs.unlinkSync(oldPath);
      }

      // Update existing entry
      existingAudio.audio = filePath;
      await existingAudio.save();

      return res.status(200).json({
        message: "Obituary background audio updated successfully",
        data: existingAudio,
      });
    } else {
      // If no entry exists, create a new one
      const newAudio = await ObituariesAudioBG.create({
        audio: filePath,
        obituaries_id: obituariesId,
      });

      return res.status(201).json({
        message: "Obituary background audio created successfully",
        data: newAudio,
      });
    }
  } catch (error) {
    console.error("Error updating background audio:", error);
    return res.status(500).json({ error: "Internal Server Error" });
  }
}


};
