//const Contact = require("../models/Contact");
const Contact = require("../models/ContactModel");

// Get all contacts
const getAllContacts = async (req, res) => {
  try {
    const contacts = await Contact.findAll();
    res.status(200).json(contacts);
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

// Create a new contact
const createContact = async (req, res) => {
  try {
    const { typeOfInjury, name, email, memorialName, message } = req.body;

    const newContact = await Contact.create({
      typeOfInjury,
      name,
      email,
      memorialName,
      message,
      status: 0, // 👈 default unread
    });

    res
      .status(201)
      .json({ message: "Contact created successfully", contact: newContact });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

// Delete contact
const deleteContact = async (req, res) => {
  try {
    const { id } = req.params;
    const contact = await Contact.findByPk(id);

    if (!contact) {
      return res.status(404).json({ error: "Contact not found" });
    }

    await contact.destroy();
    res.status(200).json({ message: "Contact deleted successfully" });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

// Count contacts by status
const countContacts = async (req, res) => {
  try {
    const unread = await Contact.count({ where: { status: 0 } });
    const read = await Contact.count({ where: { status: 1 } });
    const total = await Contact.count();

    res.status(200).json({ total, unread, read });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

// Mark a contact as read
const markAsRead = async (req, res) => {
  try {
    const { id } = req.params;
    const contact = await Contact.findByPk(id);

    if (!contact) {
      return res.status(404).json({ error: "Contact not found" });
    }

    contact.status = 1;
    await contact.save();

    res.status(200).json({ message: "Marked as read", contact });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};
const markAllAsRead = async (req, res) => {
  try {
    const [updatedCount] = await Contact.update(
      { status: 1 },
      { where: { status: 0 } } // only unread
    );

    res.status(200).json({
      message: "All contacts marked as read",
      updatedCount,
    });
  } catch (error) {
    console.error("markAllAsRead error:", error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};
module.exports = {
  getAllContacts,
  createContact,
  deleteContact,
  countContacts, 
  markAsRead,
  markAllAsRead,
};
