const paypal = require("paypal-rest-sdk");
const { signUpByPayment } = require("./userController");
// const Payment = require("../models/payment.model");
const { serverUrl, clientUrl } = require("../config/config");
const NodeCache = require("node-cache");
const myCache = new NodeCache();
const fetch = require("node-fetch");
const axios = require("axios");
const Subscription = require("../models/Subscription");
const User = require("../models/User");
const { Op } = require("sequelize");

const paypalEnv = "https://api-m.sandbox.paypal.com/v1";

paypal.configure({
  mode: "sandbox", //sandbox or live
  client_id: process.env.PAYPAL_CLIENT_ID,
  client_secret: process.env.PAYPAL_SECRETKEY,
});

const api = axios.create({
  baseURL: paypalEnv,
});

const generateToken = async () => {
  try {
    const response = await axios({
      url: `${paypalEnv}/oauth2/token`,
      method: "POST",
      data: "grant_type=client_credentials",
      auth: {
        username: process.env.PAYPAL_CLIENT_ID,
        password: process.env.PAYPAL_SECRETKEY,
      },
    });
    return response.data.access_token;
  } catch (err) {
    console.log({ err });
  }
};

function generateRequestId() {
  const timestamp = Date.now(); // Get the current timestamp
  const randomNum = Math.floor(Math.random() * 1000); // Generate a random number
  return `SUBSCRIPTION-${timestamp}-${randomNum}`; // Format the request ID
}

const activateSubscription = async ({ subId, token }) => {
  console.log({ subId, token });
  try {
    api.defaults.headers = {
      Authorization: `Bearer ${token}`,
      "Content-Type": "application/json",
    };

    const subscription = await api
      .post(`/billing/subscriptions/${subId}/activate`)
      .catch((err) => {
        console.log({ err: err.response.data.details[0] });
      });
    return subscription.data;
  } catch (err) {
    console.log({ err });
  }
};

module.exports = {
  async getClientId(req, res) {
    try {
      return res.json({
        clientId: process.env.PAYPAL_CLIENT_ID
          ? process.env.PAYPAL_CLIENT_ID
          : "Please add client id",
      });
    } catch (err) {
      console.log({ err });
      return res.status(400).json({ message: "Something went wrong!" });
    }
  },
  async getProducts(req, res) {
    try {
      const token = await generateToken();
      api.defaults.headers = {
        Authorization: `Bearer ${token}`,
        "Content-Type": "application/json",
        Accept: "application/json",
        Prefer: "return=representation",
      };
      const response = await api.get(
        "/catalogs/products?page_size=3&page=1&total_required=true"
      );
      return res.json(response.data);
    } catch (err) {
      console.log({ err });
      return res.status(400).json({ message: "Something went wrong!" });
    }
  },

  async createProduct(req, res) {
    try {
      const token = await generateToken();
      api.defaults.headers = {
        Authorization: `Bearer ${token}`,
        "Content-Type": "application/json",
        Accept: "application/json",
        Prefer: "return=representation",
      };
      // const response = await api.post(`/catalogs/products`, {
      //   name: "Monthly",
      //   description: "Monthly subscription $10/month",
      //   type: "SERVICE",
      //   category: "SOFTWARE",
      // });
      // const response = await api.post(`/catalogs/products`, {
      //   name: "Annually",
      //   description: "Annually subscription $45/month",
      //   type: "SERVICE",
      //   category: "SOFTWARE",
      // });
      const response = await api.post(`/catalogs/products`, {
        name: "Lifetime",
        description: "Lifetime subscription $145",
        type: "SERVICE",
        category: "SOFTWARE",
      });
      return res.json(response.data);
    } catch (err) {
      console.log({ err });
      return res.status(400).json({ message: "Something went wrong!" });
    }
  },

  async createPlans(req, res) {
    try {
      const token = await generateToken();
      api.defaults.headers = {
        Authorization: `Bearer ${token}`,
        Prefer: "return=representation",
      };
      const products = [
        {
          category: "SOFTWARE",
          create_time: "2024-08-25T07:01:05Z",
          description: "Monthly subscription $10/month",
          id: "PROD-8XF51436MD597532B",
          links: [
            {
              href: "https://api.sandbox.paypal.com/v1/catalogs/products/PROD-86108797WG148370F",
              method: "GET",
              rel: "self",
            },
          ],
          name: "Monthly",
          payee: {
            display_data: {},
            merchant_id: "J4WMA6EAKV7R8",
          },
          period: "MONTH",
          amount: "10",
          type: "SERVICE",
          update_time: "2024-08-25T07:01:05Z",
        },
        {
          category: "SOFTWARE",
          create_time: "2024-08-25T07:07:12Z",
          description: "Annually subscription $45/month",
          id: "PROD-3RX64232WT475880M",
          links: [
            {
              href: "https://api.sandbox.paypal.com/v1/catalogs/products/PROD-19E20809KY5431505",
              method: "GET",
              rel: "self",
            },
          ],
          name: "Annually",
          payee: {
            display_data: {},
            merchant_id: "J4WMA6EAKV7R8",
          },
          period: "YEAR",
          amount: "45",
          type: "SERVICE",
          update_time: "2024-08-25T07:07:12Z",
        },
        {
          category: "SOFTWARE",
          create_time: "2024-08-25T07:08:27Z",
          description: "Lifetime subscription $145",
          id: "PROD-4PR86272A31185420",
          links: [
            {
              href: "https://api.sandbox.paypal.com/v1/catalogs/products/PROD-2N951394YT373415S",
              method: "GET",
              rel: "self",
            },
          ],
          name: "Lifetime",
          payee: {
            display_data: {},
            merchant_id: "J4WMA6EAKV7R8",
          },
          period: "YEAR",
          amount: "145",
          type: "SERVICE",
          update_time: "2024-08-25T07:08:27Z",
        },
      ];
      const index = 2;
      const response = await api
        .post(`/billing/plans`, {
          product_id: products[index].id,
          name: products[index].name,
          description: products[index].description,
          status: "ACTIVE",
          billing_cycles: [
            {
              frequency: {
                interval_unit: products[index].period,
                interval_count: 1,
              },
              tenure_type: "REGULAR",
              sequence: 1,
              total_cycles: index === 2 ? 1 : 0, // 0 means it will bill indefinitely and 1 is for only one payment for lifetime access
              pricing_scheme: {
                fixed_price: {
                  value: products[index].amount,
                  currency_code: "USD",
                },
              },
            },
          ],
          payment_preferences: {
            auto_bill_outstanding: index === 2 ? false : true, // false for no recurring billing
            setup_fee: { value: "1", currency_code: "USD" },
            setup_fee_failure_action: "CONTINUE",
            payment_failure_threshold: 3,
          },
          taxes: { percentage: "0", inclusive: false },
        })
        .catch((err) => {
          console.log({ err });
          return res.status(400).json({ err });
        });

      return res.json(response.data);
    } catch (err) {
      console.log({ err });
      return res.status(400).json({ message: "Something went wrong!" });
    }
  },

  async updatePlan(req, res) {
    try {
      const token = await generateToken();
      // api.defaults.headers = {
      //   Authorization: `Bearer ${token}`,
      //   "Content-Type": "application/json",
      // };
      fetch(`${paypalEnv}/billing/plans/${req.params.planId}`, {
        method: "PATCH",
        headers: {
          Authorization: `Bearer ${token}`,
          "Content-Type": "application/json",
          Accept: "application/json",
        },
        body: JSON.stringify([
          {
            op: "replace",
            path: "/payment_preferences/setup_fee",
            value: 1,
          },
        ]),
      })
        .then(async (res) => {
          const data = await res.json();
          console.log({ data: data.details });
        })
        .catch((err) => {
          console.log({ err: err.data.details });
        });
      // const response = await api({
      //   url: `/billing/plans/${req.params.planId}`,
      //   method: "PATCH",
      //   headers: {
      //     Authorization: `Bearer ${token}`,
      //     "Content-Type": "application/json",
      //     Accept: "application/json",
      //   },
      //   body: JSON.stringify({
      //     op: "replace",
      //     path: "/payment_preferences/setup_fee",
      //     value: 1,
      //   }),
      // }).catch((err) => {
      //   console.log({ err: err.response.data.details });
      // });
      return res.json(response.data);
    } catch (err) {
      console.log({ err });
      return res.status(400).json({ message: "Something went wrong!" });
    }
  },

  async getPlans(req, res) {
    try {
      const access_token = await generateToken();
      const response = await api.get(
        `/billing/plans?sort_by=create_time&sort_order=desc`,
        {
          headers: {
            Authorization: `Bearer ${access_token}`,
            "Content-Type": "application/json",
            Accept: "application/json",
            Prefer: "return=representation",
          },
        }
      );

      console.log({ res: response.data });
      return res.json({
        prices: response.data,
        clientId: process.env.PAYPAL_CLIENT_ID,
      });
    } catch (err) {
      console.log({ err });
      return res.status(400).json({ message: "Something went wrong!" });
    }
  },

  async createSubscription(req, res) {
    try {
      const token = await generateToken();
      api.defaults.headers = {
        Authorization: `Bearer ${token}`,
        "Content-Type": "application/json",
        Accept: "application/json",
        "PayPal-Request-Id": generateRequestId(),
        Prefer: "return=representation",
      };
      console.log({ body: req.body });

      const response = await api.post(`/billing/subscriptions`, {
        plan_id: req.body.planId,
        // start_time: new Date().toISOString(),
        quantity: "1",
        shipping_amount: { currency_code: "USD", value: req.body.amount },
        subscriber: {
          name: {
            given_name: req.user.firstName,
            surname: req.user.lastName,
          },
          email_address: req.user.email,
        },
        application_context: {
          brand_name: "walmart",
          locale: "en-US",
          shipping_preference: "NO_SHIPPING",
          user_action: "SUBSCRIBE_NOW",
          payment_method: {
            payer_selected: "PAYPAL",
            payee_preferred: "IMMEDIATE_PAYMENT_REQUIRED",
          },
          return_url: "http://localhost:3000/activated_subscription",
          cancel_url: "http://localhost:3000/plansFeatures",
        },
      });
      // .catch((err) => {
      //   console.log({ err: err.response.data });
      //   return res.status(400).json({ message: err.response.data });
      // });
      // const activated = await activateSubscription({
      //   subId: response.data.id,
      //   token,
      // });
      // const subscription = await Subscription.create({
      //   user_id: req.user.userid,
      //   subscriptionId: response.data.id,
      //   details: JSON.stringify(response.data),
      // });
      return res.json({ data: response.data });
    } catch (err) {
      console.log({ err: err.response.data.details });
      return res.status(400).json({ message: "Something went wrong!" });
    }
  },

  async createSubDB(req, res) {
    try {
      const token = await generateToken();
      api.defaults.headers = {
        Authorization: `Bearer ${token}`,
        "Content-Type": "application/json",
      };
      const response = await api.get(
        `/billing/subscriptions/${req.body.subscriptionId}`
      );
      const subscription = await Subscription.create({
        user_id: req.user.userid,
        subscriptionId: response.data.id,
        details: JSON.stringify(response.data),
      });
      return res.json({ data: response.data, subscription });
    } catch (err) {
      console.log({ err });
      return res.status(400).json({ message: "Something went wrong!" });
    }
  },

  async getSingleSubscription(req, res) {
    try {
      const token = await generateToken();
      api.defaults.headers = {
        Authorization: `Bearer ${token}`,
        "Content-Type": "application/json",
      };
      const subscription = await api.get(
        `/billing/subscriptions/${req.params.subId}`
      );

      return res.json({ data: subscription.data });
    } catch (err) {
      console.log({ err });
      return res.status(400).json({ message: "Something went wrong!" });
    }
  },

  async getSingleSubscriptionAdmin(req, res) {
    try {
      const token = await generateToken();
      const subscription = await Subscription.findOne({
        where: { id: req.params.id },
        include: [{ model: User, as: "user" }],
      });
      api.defaults.headers = {
        Authorization: `Bearer ${token}`,
        "Content-Type": "application/json",
      };
      const response = await api.get(
        `/billing/subscriptions/${subscription.subscriptionId}`
      );
      return res.json({ subscription: response.data, user: subscription.user });
    } catch (err) {
      console.log({ err });
      return res.status(400).json({ message: "Something went wrong!" });
    }
  },

  async getSubscriptions(req, res) {
    try {
      const page = req.query.page ? req.query.page : 1;
      const pageSize = req.query.pageSize ? req.query.pageSize : 1;
      const subscriptions = await Subscription.findAndCountAll({
        where: {
          ...(req.query.search && {
            [Op.or]: [
              { "$User.firstName$": { [Op.regexp]: req.query.search } },
              { "$User.lastName$": { [Op.regexp]: req.query.search } },
              { "$User.email$": { [Op.regexp]: req.query.search } },
            ],
          }),
        },
        order: [["createdAt", "DESC"]],
        limit: parseInt(pageSize),
        offset: (parseInt(page) - 1) * parseInt(pageSize),
        include: [{ model: User, as: "user" }],
      });
      const total = Math.ceil(subscriptions.count / pageSize);
      return res.json({
        filters: { page: parseInt(page), nextPage: parseInt(page) + 1, total },
        subscriptions: subscriptions.rows,
      });
    } catch (err) {
      console.log({ err });
      return res.status(400).json({ message: "Something went wrong!" });
    }
  },
};

const paypal_copied = async () => {
  // monthly
  // <div id="paypal-button-container-P-30C13946K96613829M3EKEWI"></div>
  // <script src="https://www.paypal.com/sdk/js?client-id=AW4ZW2K0-Fb3Nyt7Y4fIV1USWFsYTPI4UIk9bYFed2ghuIDMPWCOyWWNrXsShdBEd4Z-Tix-NAJzLBS3&vault=true&intent=subscription" data-sdk-integration-source="button-factory"></script>
  // <script>
  //   paypal.Buttons({
  //       style: {
  //           shape: 'rect',
  //           color: 'gold',
  //           layout: 'vertical',
  //           label: 'subscribe'
  //       },
  //       createSubscription: function(data, actions) {
  //         return actions.subscription.create({
  //           /* Creates the subscription */
  //           plan_id: 'P-30C13946K96613829M3EKEWI'
  //         });
  //       },
  //       onApprove: function(data, actions) {
  //         alert(data.subscriptionID); // You can add optional success message for the subscriber here
  //       }
  //   }).render('#paypal-button-container-P-30C13946K96613829M3EKEWI'); // Renders the PayPal button
  // </script>
  // Annually
  // 	<div id="paypal-button-container-P-77V14339FA210394LM3EKFHI"></div>
  // <script src="https://www.paypal.com/sdk/js?client-id=AW4ZW2K0-Fb3Nyt7Y4fIV1USWFsYTPI4UIk9bYFed2ghuIDMPWCOyWWNrXsShdBEd4Z-Tix-NAJzLBS3&vault=true&intent=subscription" data-sdk-integration-source="button-factory"></script>
  // <script>
  //   paypal.Buttons({
  //       style: {
  //           shape: 'rect',
  //           color: 'gold',
  //           layout: 'vertical',
  //           label: 'subscribe'
  //       },
  //       createSubscription: function(data, actions) {
  //         return actions.subscription.create({
  //           /* Creates the subscription */
  //           plan_id: 'P-77V14339FA210394LM3EKFHI'
  //         });
  //       },
  //       onApprove: function(data, actions) {
  //         alert(data.subscriptionID); // You can add optional success message for the subscriber here
  //       }
  //   }).render('#paypal-button-container-P-77V14339FA210394LM3EKFHI'); // Renders the PayPal button
  // </script>
  // lifetime
  // 	<div id="paypal-button-container-P-4WF37592RP232101HM3EKF6I"></div>
  // <script src="https://www.paypal.com/sdk/js?client-id=AW4ZW2K0-Fb3Nyt7Y4fIV1USWFsYTPI4UIk9bYFed2ghuIDMPWCOyWWNrXsShdBEd4Z-Tix-NAJzLBS3&vault=true&intent=subscription" data-sdk-integration-source="button-factory"></script>
  // <script>
  //   paypal.Buttons({
  //       style: {
  //           shape: 'rect',
  //           color: 'gold',
  //           layout: 'vertical',
  //           label: 'subscribe'
  //       },
  //       createSubscription: function(data, actions) {
  //         return actions.subscription.create({
  //           /* Creates the subscription */
  //           plan_id: 'P-4WF37592RP232101HM3EKF6I'
  //         });
  //       },
  //       onApprove: function(data, actions) {
  //         alert(data.subscriptionID); // You can add optional success message for the subscriber here
  //       }
  //   }).render('#paypal-button-container-P-4WF37592RP232101HM3EKF6I'); // Renders the PayPal button
  // </script>
};
