const ServiceContactModel = require("../models/ServiceContactModel")

 
const createContact = async (req, res) => {
    try {
        const {
            name,    
            email,
            subject,
            message,
            userid
        } = req.body;

        // Create a new contact
        const newContact = await ServiceContactModel.create({
             name,    
            email,
            subject,
            message,
            user_id:userid
            
        });

        res.status(201).json({ message: 'Contact created successfully', contact: newContact });
    } catch (error) {
        console.error(error);
        res.status(500).json({ error: 'Internal Server Error' });
    }
};



module.exports = {

    createContact 

};
