// models/HelpTicket.js
const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");

const HelpTicket = sequelize.define("HelpTicket", {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true,
  },
  user_id: {
    type: DataTypes.INTEGER,
    allowNull: false,
  },
  email: {              
    type: DataTypes.STRING,
    allowNull: false,
    validate: { isEmail: true },
  },
  subject: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  status: {
    type: DataTypes.ENUM("open", "closed"),
    defaultValue: "open",
  },
  messages: {
    type: DataTypes.JSON,   // Array of message objects [{ sender_id, message, created_at }]
    allowNull: false,
    defaultValue: [],
  },
}, {
  tableName: "help_tickets",
  timestamps: true,
  createdAt: "created_at",
  updatedAt: "updated_at",
});

module.exports = HelpTicket;
