// models/Contact.js

const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User");

const ServiceContact = sequelize.define(
  "serviceContact",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
     user_id: {
          type: DataTypes.INTEGER,
          allowNull: false,
          references: {
            model: User,
            key: "userid",
          },
        },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    email: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    subject: {
      type: DataTypes.STRING,
    },
    message: {
      type: DataTypes.TEXT,
      allowNull: false,
    },
  },
  {
    tableName: "serviceContact",
    timestamps: false,
  }
);

ServiceContact.belongsTo(User, { foreignKey: "user_id", as: "user" });
module.exports = ServiceContact;
