const { DataTypes } = require("sequelize");
const path = require("path");
const sequelize = require(path.join(__dirname, "../config/database"));

const TributeLike = sequelize.define(
  "TributeLike",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    tribute_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    ip_address: {
      type: DataTypes.STRING,
      allowNull: true, // Optional: to limit abuse
    },
  },
  {
    tableName: "tribute_likes",
    timestamps: true,
    createdAt: "liked_at",
    updatedAt: false,
  }
);

module.exports = TributeLike;
