// models/CoverTemplate.js
const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");


const CoverTemplate = sequelize.define(
  "CoverTemplate",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: false,
    },
    file_path: {
      type: DataTypes.STRING(1024),
      allowNull: false,
    },
    preview_path: {
      type: DataTypes.STRING(1024),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    is_active: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    tableName: "cover_templates",
    timestamps: true,
    underscored: true,
    createdAt: "created_at",
    updatedAt: "updated_at",
  }
);

// If you wire associations via model files instead of an index, you can add them like this.
// Uncomment and adjust if you want to relate to other models.
// CoverTemplate.associate = (models) => {
//   CoverTemplate.hasMany(models.Memorial, {
//     foreignKey: "cover_template_id",
//     as: "memorials",
//   });
// };

module.exports = CoverTemplate;
