const express = require("express");

const path = require("path");

const passport = require("passport");
const multer = require("multer");
const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    console.log({ fileType: file });
    const fileType = (file.mimetype.includes("audio") && "audio") || "images";
    const destinationPath = `public/${fileType}/`;
    cb(null, destinationPath);
  },
  filename: function (req, file, cb) {
    cb(
      null,
      file.fieldname + "-" + Date.now() + path.extname(file.originalname)
    );
  },
});
const upload = multer({ storage });
const { createObituaryAudioBackground , getObituaryAudioBackground ,updateObituaryAudioBackground } = require("../controller/ObituariesMedia");
const router = express.Router();

// Route with multer + error handling middleware
router.post(
  "/:obituariesId",
   upload.single("audio"),
  createObituaryAudioBackground
);

router.get('/:obituariesId', getObituaryAudioBackground);
router.put(
  "/obituary/audio-background/:obituariesId",
  upload.single("audio"),
  updateObituaryAudioBackground
);


module.exports = router;
