const express = require("express");
const router = express.Router();
const passport = require("passport");
const { authenticateToken, checkSuperAdmin } = require("../middlewares/user.middleware");
const anniversaryCtrl = require("../controller/anniversary.controller");

// GET all anniversaries
router.get(
  "/",
  authenticateToken,
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  anniversaryCtrl.getAllAnniversaries
);

// GET one
router.get(
  "/:id",
  authenticateToken,
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  anniversaryCtrl.getAnniversary
);

// UPDATE
router.put(
  "/:id",
  authenticateToken,
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  anniversaryCtrl.updateAnniversary
);

// DELETE
router.delete(
  "/:id",
  authenticateToken,
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  anniversaryCtrl.deleteAnniversary
);

module.exports = router;
