const express = require("express");
const router = express.Router();
const path = require("path");
const multer = require("multer");

const {
  create,
  getAllCategories,
  categoriesFilter,
  singleCategory,
  removeCategory,
  updateCategory,
  getMemorialsByCategory, // ✅ added import
} = require("../controller/categories");

// Multer storage config
const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const fileType = (file.mimetype.includes("audio") && "audio") || "images";
    const destinationPath = `public/${fileType}/`;
    cb(null, destinationPath);
  },
  filename: function (req, file, cb) {
    cb(
      null,
      file.fieldname + "-" + Date.now() + path.extname(file.originalname)
    );
  },
});
const upload = multer({ storage });

// Routes
router.post("/create", upload.single("image"), create);
router.put("/update/:id", upload.single("image"), updateCategory);
router.delete("/remove/:id", removeCategory);

router.get("/filtered-data", categoriesFilter);
router.get("/single/:id", singleCategory);
router.get("/:id/memorials", getMemorialsByCategory); 
router.get("/", getAllCategories);

module.exports = router;
