// routes/dashboard.js
const express = require("express");
const router = express.Router();

const Memorial = require("../models/Memorial");
const Obituary = require("../models/Obituary");
const Testimonial = require("../models/Testimonial");
const User = require("../models/User");

router.get("/stats", async (req, res) => {
  try {
    const [
      memorials,
      obituaries,
      testimonials,
      users,
      serviceProviders,
      latestMemorials,
      latestObituaries,
    ] = await Promise.all([
      // counts
      Memorial.count(),
      Obituary.count(),
      Testimonial.count(),
      User.count(),
      User.count({ where: { type: "service_provider" } }),

      // latest 5 memorials (use your real date column)
      Memorial.findAll({
        limit: 5,
        order: [["CreatedOn", "DESC"]],
        attributes: [
          "id",
          "Firstname",
          "MiddleName",
          "LastName",
          "Gender",
          "Relationship",
          "Plan",
          "CreatedOn",
        ],
      }),

      // latest 5 obituaries — respect alias and columns from your model
      Obituary.findAll({
        limit: 5,
        order: [["CreatedOn", "DESC"]],
        attributes: [
          "id",
          "obituaryTitle",
          "description",
          "user_id",
          "CreatedOn",
        ],
        include: [
          {
            model: User,
            as: "user", // <-- important: match the alias in your association
            attributes: ["userid", "firstName", "lastName"],
          },
        ],
      }),
    ]);

    res.json({
      counts: {
        memorials,
        obituaries,
        testimonials,
        users,
        serviceProviders,
      },
      latest: {
        memorials: latestMemorials,
        obituaries: latestObituaries,
      },
    });
  } catch (error) {
    console.error("Error fetching dashboard stats:", error);
    res.status(500).json({ error: "Internal Server Error" });
  }
});

module.exports = router;
