const express = require("express");
const router = express.Router();
const path = require("path"); // <-- required
const { create , getAll ,getById , updateserviceRenewal , deleteService} = require("../controller/serviceDetail");
const multer = require("multer");

const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const destinationPath = "public/images/"; // keep it simple
    cb(null, destinationPath);
  },
  filename: function (req, file, cb) {
    cb(
      null,
      file.fieldname + "-" + Date.now() + path.extname(file.originalname)
    );
  },
});

const upload = multer({ storage });

// Ensure the input name is "image" in your frontend/form
router.post("/create", upload.single("image"), create);
router.get("/get", getAll);         
router.get("/service/:id", getById);     
router.put("/:id/renewal", updateserviceRenewal);
router.delete('/service-detail/:id', deleteService);



module.exports = router;
