const express = require("express");
const router = express.Router();
const serviceController = require("../controller/serviceController");

// Create new service
router.post("/", serviceController.createService);

// Get all services
router.get("/get", serviceController.getAllServices);

// Get single service by id
router.post("/:id", serviceController.getServiceById);

// Update service
router.put("/:id", serviceController.updateService);

// Delete service
router.delete("/:id", serviceController.deleteService);

module.exports = router;
