const express = require("express");
const router = express.Router();

const multer = require("multer");
const path = require("path");

// Configure storage options for Multer
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    const fileType = req.fileType || "images";  // default to 'images' folder
    const destinationPath = `public/${fileType}/`;
    cb(null, destinationPath);  // Set the destination path
  },
  filename: (req, file, cb) => {
    const fileName = `${file.fieldname}-${Date.now()}${path.extname(file.originalname)}`;
    cb(null, fileName);  // Set the filename with timestamp to avoid collision
  },
});

const upload = multer({ storage });

const {
  create,
  getStoriesByMemorial, 
  getAllStories,
  getStory,
  updateStory,
  removeStory,
  getStoriesByCoAdmins,
} = require("../controller/stories");

router.post("/create",upload.single("image"), create);
router.get("/get-by-memorial/:memorialId", getStoriesByMemorial);
router.get("/story/:id", getStory);
router.get("/by-coadmin/:userId", getStoriesByCoAdmins);

router.put("/update/:id", updateStory);

router.delete("/remove/:id", removeStory);

router.get("/", getAllStories);

module.exports = router;
