import FormSubmission from "../models/FormSubmission.js";

// 👇 Called from frontend
export const submitForm = async (req, res) => {
  try {
    const { data } = req.body; // Make sure you're sending { data: [...] } from frontend

    const saved = await FormSubmission.create({ formData: data });

    res.status(201).json({ message: "Form saved", id: saved._id });
  } catch (err) {
    res.status(500).json({ message: "Error saving form", error: err.message });
  }
};

// 👇 For admin panel or listing all submitted forms
export const getAllSubmissions = async (req, res) => {
  try {
    const submissions = await FormSubmission.find().sort({ createdAt: -1 });
    res.status(200).json(submissions);
  } catch (err) {
    res.status(500).json({ message: "Error fetching", error: err.message });
  }
};
