import mongoose from "mongoose";

const membershipSchema = new mongoose.Schema({
 
  serviceName: { type: String, required: true },
  description: { type: String },
  price: { type: Number, default: 0 },
  isRecurring: { type: Boolean, default: false },
  duration: {
    value: { type: Number, default: 1 },
    unit: { type: String, enum: ["days", "weeks", "months", "years"], default: "months" },
  },
  DurationPeriod:{type : String},
  salesTax: { type: String },
  includedSessions: { type: Number, default: 0 },
  maxBookings: { type: Number, default: 0 },
  displayOnBookingPage: { type: Boolean, default: true },
image: { type: String },
  enableLimit: { type: Boolean, default: true },
  packageLimit: { type: Number },
  maxPackages: { type: Number },
  unlimited: { type: Boolean, default: true },
  position: { type: String, default: "Plan TRT" },
}, { timestamps: true });

export default mongoose.model("Membership", membershipSchema);
