import multer from 'multer';
import path from 'path';
import fs from 'fs';

const rootPath = path.resolve(); // project root (e.g., C:/xampp/htdocs/Duralux)

export const uploadSingle = (subfolder = '') => {
  const storage = multer.diskStorage({
    destination: function (req, file, cb) {
      const folderPath = path.join(rootPath, 'server', 'upload', subfolder); // ✅ inside upload/

      if (!fs.existsSync(folderPath)) {
        fs.mkdirSync(folderPath, { recursive: true });
      }

      cb(null, folderPath);
    },
    filename: function (req, file, cb) {
      const ext = path.extname(file.originalname);
      const fileName = `${Date.now()}${ext}`;
      cb(null, fileName);
    },
  });

  return multer({ storage }).single('image'); // expects <input name="image" />
};

export const uploadMultiple = (subfolder = '', fieldName = 'images', maxCount = 5) => {
  const storage = multer.diskStorage({
    destination: function (req, file, cb) {
      const folderPath = path.join(rootPath, 'server', 'upload', subfolder); // ✅ inside upload/

      if (!fs.existsSync(folderPath)) {
        fs.mkdirSync(folderPath, { recursive: true });
      }

      cb(null, folderPath);
    },
    filename: function (req, file, cb) {
      const ext = path.extname(file.originalname);
      const fileName = `${Date.now()}-${file.originalname}`;
      cb(null, fileName);
    },
  });

  return multer({ storage }).array(fieldName, maxCount);
};
