import mongoose from 'mongoose';

const serviceSchema = new mongoose.Schema({
  name: {
    type: String,
    required: true,
  },
  description: {
    type: String,
  },
  display: {
    type: Boolean,
    default: false,
  },
  price: {
    type: Number,
    default: 0,
  },
  tax: {
    type: String,
    enum: ['0%', '5%', '10%', ''],
    default: '',
  },
  image: {
    type: String, // Store the file URL or path
    default: '',
  },
}, { timestamps: true });

const Service = mongoose.model("Service", serviceSchema);
export default Service;

