// routes/clientRoutes.js
import express from 'express';
import {
  createClient,
  getAllClients,
  getClientById,
  updateClient,
  deleteClient,
  blockClient,
  deleteMultipleClients,
  blockMultipleClients,
  sendOtp,
  resetPasswordController
} from '../controllers/clientController.js';

import { protect } from '../middleware/authMiddleware.js'; // optional if needed
import { uploadSingle } from '../utils/uploadHelper.js';

const router = express.Router();

// Routes for managing client data

// Create a new client with image upload
router.post('/store', uploadSingle('client_images'), createClient);

// Get all clients
router.get('/', getAllClients);

// Get a specific client by ID
router.get('/:id', getClientById);

// Update a client (with optional image)
router.put('/:id', uploadSingle('client_images'), updateClient);

router.patch('/block/:id', blockClient);
// Delete a client
router.delete('/:id', deleteClient);
router.post('/delete-multiple', deleteMultipleClients);

router.post('/block-multiple', blockMultipleClients);

router.post('/send-otp', sendOtp);
// routes/client.js
router.post("/reset-password", resetPasswordController);



export default router;
