import express from 'express';
import {
    updateServiceProvider,
    saveServiceProvider,
    getService,
    updateProviderServices,
    saveProviderServices
 
} from '../controllers/serviceProviderController.js';
import { protect } from '../middleware/authMiddleware.js';

import  upload  from '../middleware/upload.js';

const router = express.Router();


router.put('/service-providers/:id', updateServiceProvider);

router.post('/service-providers', saveServiceProvider);

router.get('/services', getService); 

router.put('/provider-services/:id', updateProviderServices);

router.post('/provider-services', saveProviderServices);


export default router;