import express from 'express';
import http from 'http';
import cors from 'cors';
import dotenv from 'dotenv';
import connectDB from './config/db.js';
import authRoutes from './routes/authRoutes.js';
import clientRoutes from './routes/clientRoutes.js';
import locationRoutes from './routes/locationRoutes.js'
import serviceProviderRoutes from './routes/serviceProviderRoutes.js'
import serviceRoutes from './routes/serviceRoutes.js'
import userRoutes from './routes/userRoutes.js'
import { initSocket } from './utils/socket.js';

dotenv.config();
connectDB();

const app = express();
const server = http.createServer(app);

// Middleware
app.use(cors());
app.use(express.json());
app.use('/uploads', express.static('uploads'));

// Routes
app.use('/api/auth', authRoutes);
app.use('/api/auth', locationRoutes);
app.use('/api/auth', serviceProviderRoutes);
app.use('/api/auth', serviceRoutes);
app.use('/api/auth', userRoutes);
app.use('/api/client', clientRoutes);

// Init socket
initSocket(server);

const PORT = process.env.PORT || 5000;
server.listen(PORT, () => console.log(`Server running on port ${PORT}`));
