// server/models/FormSchema.js
import mongoose from "mongoose";

const formSchema = new mongoose.Schema(
  {
    title: String,
    description: String,
    schema: {
      type: Array,
      required: true,
    },
    createdBy: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
    },
    status: {
      type: String,
      enum: ["pending", "approved", "rejected"],
      default: "pending",
    },
    approvedBy: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
    },
  },
  { timestamps: true }
);

const FormSchema = mongoose.model("FormSchema", formSchema);
export default FormSchema;
