// server/models/FormSubmission.js
import mongoose from "mongoose";

const formSubmissionSchema = new mongoose.Schema(
  {
    formId: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "FormSchema",
    },
    submittedBy: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
    },
    values: Array,
  },
  { timestamps: true }
);

// 👇 Default export only (no named export)
const FormSubmission = mongoose.model("FormSubmission", formSubmissionSchema);
export default FormSubmission;
