import mongoose from "mongoose";

const issuePackageAssignedToClientSchema = new mongoose.Schema({
  issuePackageId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'issuedPackage',
    required: true,
  },
  packageId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Package',
    required: true,
  },
  assignedClients: [
    {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'User',
      required: true,
    }
  ],
  issueDate: {
    type: Date,
    default: Date.now,
  },
});

const IssuePackageAssignedToClient = mongoose.model(
  'IssuePackageAssignedToClient',
  issuePackageAssignedToClientSchema
);

export default IssuePackageAssignedToClient;
