// models/ProviderLocation.js
import mongoose from 'mongoose';

const providerLocationSchema = new mongoose.Schema({
  providerId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Provider',
    required: true,
  },
  locationIds: [
    {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'Location',
    }
  ],
}, { timestamps: true });

export default mongoose.model('ProviderLocation', providerLocationSchema);
