import mongoose from 'mongoose';

const ServicePageProviderSchema = new mongoose.Schema({
  ServicePageId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Service',
    required: true,
  },
  providers: [{
    type: mongoose.Schema.Types.ObjectId,
    ref: 'ServiceProvider' // ← this should be your Provider model name
  }],
}, { timestamps: true });

export default mongoose.model('ServicePageProvider', ServicePageProviderSchema);
