
import mongoose from 'mongoose';

const ServiceTimeSchema = new mongoose.Schema({
  categoryId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "Service", // Make sure Category model exists
    required: true,
  },
  duration: {
    hours: { type: String, required: true },
    minutes: { type: String, required: true },
  },
  bufferTimeAdded: { type: Boolean, default: false },
  hideDuration: { type: Boolean, default: false },
  allowTimeBeforeBooking: { type: Boolean, default: false },
  fixedTimeAppointment: { type: Boolean, default: false },
  recurringService: { type: Boolean, default: false },
  recurringSettings: {
    sessions: Number,
    repeatDays: [String],
    repeatInterval: Number,
    dateOption: { type: String, enum: ["notAllow", "skipUnavailable", "addEnd"] },
  },
  minBookingTime: { type: String },
  maxBookingTime: { type: String },
}, {
  timestamps: true,
});

const ServiceTime = mongoose.model("ServiceTime", ServiceTimeSchema);
export default ServiceTime
