const braintree = require("braintree");

const gateway = new braintree.BraintreeGateway({
  environment: braintree.Environment.Sandbox,
  merchantId: "zwnjqqyv8c8x7bhg",
  publicKey: "hrgpt2rfffrmzzm2",
  privateKey: "3978199ef5007c7cfa4f93e999633bed",
});

module.exports = {
  async generateClientToken(req, res) {
    try {
      const token = await gateway.clientToken.generate();
      return res.json(token);
    } catch (err) {
      console.log({ err });
      return res.status(400).json({ err });
    }
  },

  async createPlans(req, res) {
    try {
      const plans = [
        {
          name: "Month", // Name of the plan
          billingFrequency: 1, // Billing frequency in months
          currencyIsoCode: "USD", // Currency code
          price: "10.00", // Price of the plan
          numberOfBillingCycles: 1, // Number of billing cycles (12 months)
          trialPeriod: false, // Indicates if there is a trial period
          description: "Monthly subscription $10/month.", // Description of the plan
        },
        {
          name: "Year", // Name of the plan
          billingFrequency: 1, // Billing frequency in months
          currencyIsoCode: "USD", // Currency code
          price: "45.00", // Price of the plan
          numberOfBillingCycles: 12, // Number of billing cycles (12 months)
          trialPeriod: false, // Indicates if there is a trial period
          description: "Annually subscription $45/year.", // Description of the plan
        },
        {
          name: "Lifetime", // Name of the plan
          billingFrequency: 1, // Billing frequency in months
          currencyIsoCode: "USD", // Currency code
          price: "145.00", // Price of the plan (one-time payment)
          numberOfBillingCycles: null, // No expiration, lifetime subscription
          trialPeriod: false, // No trial period
          description: "This plan provides lifetime access to all features.", // Description of the plan
        },
      ];
      const index = 2;
      const result = await gateway.plan.create(plans[index]);
      return res.json(result);
    } catch (err) {
      console.log({ err });
      return res.status(400).json({ err });
    }
  },

  async getPlans(req, res) {
    try {
      const result = await gateway.plan.all();
      const plans = result.sort((a, b) => {
        return new Date(a.createdAt) - new Date(b.createdAt);
      });
      return res.json(plans);
    } catch (err) {
      console.log({ err });
      return res.status(400).json({ err });
    }
  },
};
