const { Op } = require("sequelize");
const Promocode = require("../models/Promocode");

module.exports = {
  async create(req, res) {
    try {
      const foundCoupon = await Promocode.findOne({
        where: { code: req.body.code },
      });
      if (foundCoupon)
        return res
          .status(400)
          .json({ message: "Code already exists! Please regenerate new one." });
      const coupon = new Promocode(req.body);
      await coupon.save();
      return res.json(coupon);
    } catch (err) {
      console.log({ err });
      return res.status(500).json({ message: "Something went wrong!" });
    }
  },
  async allPromocodes(req, res) {
    try {
      const page = req.query.page ? req.query.page : 1;
      const pageSize = req.query.pageSize ? req.query.pageSize : 4;
      const promocode = await Promocode.findAndCountAll({
        where: {
          ...(req.query.search && {
            [Op.or]: [
              { code: { [Op.regexp]: req.query.search } },
              { discount: { [Op.regexp]: req.query.search } },
            ],
          }),
        },
        limit: parseInt(pageSize),
        offset: (parseInt(page) - 1) * parseInt(pageSize),
        order: [["createdAt", "DESC"]],
      });
      const total = Math.ceil(promocode.count / pageSize);
      return res.status(201).json({
        filters: { page: parseInt(page), nextPage: parseInt(page) + 1, total },
        promocodes: promocode.rows,
      });
    } catch (error) {
      console.error(error);
      return res.status(500).json({ error: "Internal Server Error" });
    }
  },

  async findCoupon(req, res) {
    console.log(req.params);
    try {
      const coupon = await Promocode.findOne({
        where: { code: req.params.code },
      });
      if (!coupon)
        return res.status(400).json({ message: "Coupon does not exist!" });
      return res.json(coupon);
    } catch (error) {
      console.error(error);
      return res.status(500).json({ error: "Internal Server Error" });
    }
  },

  async removeCoupon(req, res) {
    try {
      const coupon = await Promocode.findOne({ where: { id: req.params.id } });
      await coupon.destroy();
      return res.json({ message: "Coupon is removed successfully!" });
    } catch (err) {
      console.error(err);
      return res.status(500).json({ error: "Internal Server Error" });
    }
  },
};
