const TributeLike = require("../models/TributeLike");

// GET /api/tribute/:id/likes
exports.getLikes = async (req, res) => {
  try {
    const tributeId = req.params.id;
    const count = await TributeLike.count({
      where: { tribute_id: tributeId },
    });
    res.status(200).json({ likes: count });
  } catch (err) {
    console.error("Error getting likes:", err);
    res.status(500).json({ error: "Server error" });
  }
};

// POST /api/tribute/:id/like
exports.addLike = async (req, res) => {
  const tributeId = req.params.id;
  const ip = req.ip;

  try {
    // Optional: prevent multiple likes from same IP
    const alreadyLiked = await TributeLike.findOne({
      where: {
        tribute_id: tributeId,
        ip_address: ip,
      },
    });

    if (alreadyLiked) {
      return res.status(400).json({ message: "Already liked" });
    }

    await TributeLike.create({
      tribute_id: tributeId,
      ip_address: ip,
    });

    res.status(201).json({ success: true });
  } catch (err) {
    console.error("Error adding like:", err);
    res.status(500).json({ error: "Server error" });
  }
};
