const multer = require("multer");
const path = require("path");

// Configure Multer for file uploads
const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const fileType = req.fileType || "images";
    const destinationPath = `public/${fileType}/`;
    cb(null, destinationPath);
  },
  filename: function (req, file, cb) {
    cb(
      null,
      file.fieldname + "-" + Date.now() + path.extname(file.originalname)
    );
  },
});

const upload = multer({ storage });

// Function to handle file uploads
const uploadFile = (fileType) => async (req, res, next) => {
  try {
    if (req.file) {
      req.fileType = fileType;

      upload.single("file")(req, res, async (err) => {
        if (err instanceof multer.MulterError) {
          // A Multer error occurred when uploading
          console.error("Multer error:", err);
          return res.status(500).send("Internal server error");
        } else if (err) {
          // An unknown error occurred when uploading
          console.error("Unknown error:", err);
          return res.status(500).send("Internal server error");
        } else if (!req?.file?.path) {
          return res.status(500).send("Internal server error");
        }
        let filePath = req?.file?.path;
        filePath = filePath.replace("public", "api");
        req.file.path = filePath;
        // Process the uploaded file here
        console.log("File upload", filePath);
        // return res.status(200).send(filePath);
        next(); // Continue to the next middleware
      });
    }
  } catch (error) {
    console.error("Error handling file upload:", error);
    return res.status(500).send("Internal server error");
  }
};

// Define upload functions for different file types
const uploadImage = uploadFile("images");
const uploadAudio = uploadFile("audio");
const uploadVideo = uploadFile("videos");
const uploadProfileImage = uploadFile("profile");

module.exports = {
  uploadImage,
  uploadAudio,
  uploadVideo,
  uploadProfileImage,
};
