const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User");
const Anniversary = require("./Anniversary");

const Comment = sequelize.define(
  "Comment",
  {
    id: { 
      type: DataTypes.INTEGER, 
      primaryKey: true, 
      autoIncrement: true 
    },
    anniversary_id: { 
      type: DataTypes.INTEGER,
      allowNull: false,
      references: { model: "anniversaries", key: "id" },
      onDelete: "CASCADE",
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: { model: "users", key: "id" },
      onDelete: "CASCADE",
    },
    comment: {
      type: DataTypes.TEXT,
      allowNull: false,
      validate: {
        len: [1, 2000],
      },
    },
  },
  {
    tableName: "comments",
    timestamps: false,   // 🚀 add this line
  }
);

// Associations
Comment.belongsTo(User, { foreignKey: "user_id" });
Comment.belongsTo(Anniversary, { foreignKey: "anniversary_id" });
Anniversary.hasMany(Comment, { foreignKey: "anniversary_id" });
User.hasMany(Comment, { foreignKey: "user_id" });

module.exports = Comment;
