// models/EventContent.js

const { DataTypes } = require('sequelize');
const sequelize = require('../config/database');
const Memorial = require('./Memorial'); // Import the Memorial model

const EventContent = sequelize.define('EventContent', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true,
    allowNull: false
  },
  eventsType: {
    type: DataTypes.STRING,
    allowNull: false,
    field: 'eventsType'
  },
  title: {
    type: DataTypes.STRING,
    allowNull: true
  },
  subTitle: {
    type: DataTypes.TEXT('long'),
    allowNull: true,
    field: 'subTitle'
  },
  descriptionText: {
    type: DataTypes.TEXT('long'),
    allowNull: true,
    field: 'descriptionText'
  },
  createdBy: {
    type: DataTypes.STRING,
    allowNull: true,
    field: 'CreatedBy'
  },
  createdOn: {
    type: DataTypes.DATE,
    allowNull: true,
    field: 'CreatedOn'
  },
  memorialId: {
    type: DataTypes.INTEGER,
    allowNull: true,
    field: 'memorial_id'
  }
}, {
  tableName: 'event_content',
  timestamps: false
});

// Define association with Memorial model
EventContent.belongsTo(Memorial, { foreignKey: 'memorialId' });

module.exports = EventContent;
