// models/Journey.js

const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User"); // Import the User model
const Memorial = require("./Memorial");

const Journey = sequelize.define(
  "Journey",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: User,
        key: "userid",
      },
    },
    title: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    image: {
      type: DataTypes.STRING,
    },
    description: {
      type: DataTypes.TEXT("long"),
    },
    memorial_id: {
      type: DataTypes.INTEGER,
      references: {
        model: Memorial,
        key: "id",
      },
    },
  },
  {
    tableName: "journey",
    timestamps: true,
  }
);

Journey.belongsTo(User, { foreignKey: "user_id", as: "user" });
Journey.belongsTo(Memorial, { foreignKey: "memorial_id", as: "memorial" });

// Journey.sync({ alter: true });
//   .then(() => {
//     console.log("New table created.");
//   })
//   .catch((error) => {
//     console.error("Error creating new table:", error);
//   });

// const tableName = "journey";
// const query = `SHOW TABLES LIKE '${tableName}'`;

// function timer() {
//   setTimeout(() => {
//     sequelize
//       .query(query)
//       .then((results) => {
//         if (results.length === 0) {
//           Journey.sync({ force: false })
//             .then(() => {
//               console.log("New table created.");
//             })
//             .catch((error) => {
//               console.error("Error creating new table:", error);
//             });
//         } else {
//           console.log("Table already exists.");
//         }
//       })
//       .catch((error) => {
//         console.error("Error checking table existence:", error);
//       });
//   }, 2000);
// }
// timer();

module.exports = Journey;
