// models/MemorialAudioBG.js

const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const Obituary = require("./Obituary");

const ObituariesAudioBG = sequelize.define(
  "ObituariesAudioBG",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    audio: {
      type: DataTypes.STRING,
    },
    obituaries_id: {
      type: DataTypes.INTEGER,
      references: {
        model: Obituary,
        key: "id",
      },
    },
  },
  {
    tableName: "Obituaries_AudioBG",
    timestamps: true,
  }
);


module.exports = ObituariesAudioBG;
