const express = require("express");
const router = express.Router();
const auth = require("../middlewares/auth"); 
const {
  create,
  index,
  getByMemorial,
  getSingleAnniversary,
  update,
  remove,
  getAnniversariesByCoAdmins,
  AddComment,
  GetComments,
  UpdateComment,
  DeleteComment,
  getAnniversariesByUser
} = require("../controller/anniversaries");

router.post("/create", create);
router.put("/update/:id", update);
router.delete("/remove/:id", remove);

router.get("/by-memorial/:id", getByMemorial);
router.get("/by-coadmin/:userId", getAnniversariesByCoAdmins);
router.get("/by-user/:userId", getAnniversariesByUser);
router.get("/single/:id", getSingleAnniversary);
router.get("/", index);
router.post("/comment", AddComment);
router.get("/comments/:anniversary_id", GetComments);
router.put("/update/comment/:id", UpdateComment);
router.delete("/comment/:id", DeleteComment);

module.exports = router;
