const express = require("express");
const router = express.Router();
const passport = require("passport");
const { authenticateToken, checkSuperAdmin } = require("../middlewares/user.middleware");
const memorialTributeCtrl = require("../controller/memorialTribute.controller");

// ✅ GET all memorial tributes (super admin only)
router.get(
  "/",
  authenticateToken,
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  memorialTributeCtrl.getAllMemorialTributes
);

// ✅ GET single tribute by id
router.get(
  "/:id",
  authenticateToken,
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  memorialTributeCtrl.getMemorialTribute
);

// ✅ UPDATE tribute by id
router.put(
  "/:id",
  authenticateToken,
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  memorialTributeCtrl.updateMemorialTribute
);

// ✅ DELETE tribute by id
router.delete(
  "/:id",
  authenticateToken,
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  memorialTributeCtrl.deleteMemorialTribute
);

module.exports = router;
